// File: CEG_Logon.hpp
// Version: 1.1
// Author: Loyalguard
// Description: Define dialog classes and related controls for the grid control sytsem logon dialog.

class CEG_Logon
{
	idd = 20900;
	movingEnable = false;
	
	controlsBackground[] = 
	{
		CEG_WindowBackground_Rect,
		CEG_Popup,
		CEG_PasswordRect
	};
	
	objects[] = { };
	
	controls[] = 
	{
		CEG_WindowHeaderRect,
		CEG_WindowHeaderText,
		CEG_WindowIconPicture,
		CEG_PasswordInput,
		CEG_IncorrectText,
		CEG_PasswordLabel,
		CEG_OKButton,
		CEG_CancelButton
	};

	// BACKGROUND CONTROL CLASSES //

	class CEG_WindowBackground_Rect : CEG_StaticRect
	{

		x = (safeZoneX + (safeZoneW * 0.0));
		y = (safeZoneY + (safeZoneH * 0.00)); 
		w = (safeZoneW * 1);
		h = (safeZoneH * 1);
		colorBackground[] = CEG_COLOR_BLACK;
	};
	
	class CEG_Popup : CEG_Window
	{
		x = (safeZoneX + (safeZoneW * 0.275));
		y = (safeZoneY + (safeZoneH * 0.3));
		w = (safeZoneW * 0.4);
		h = (safeZoneH * 0.25);
		colorBackground[] = CEG_COLOR_LTGRAY;
	};
	
	 class CEG_PasswordRect : CEG_StaticRect
	{
		x = (safeZoneX + (safeZoneW * 0.425));
		y = (safeZoneY + (safeZoneH * 0.425));
		w = (safeZoneW * 0.2);
		h = (safeZoneH * 0.04);
		colorBackground[] = CEG_COLOR_WHITE;
	};
	
	// CONTROL CLASSES //

	// GUI Window Controls

	class CEG_WindowHeaderRect : CEG_Window
	{
		x = (safeZoneX + (safeZoneW * 0.275));
		y = (safeZoneY + (safeZoneH * 0.3));
		w = (safeZoneW * 0.4);
		h = (safeZoneH * 0.05);
		colorBackground[] = CEG_COLOR_BLUE;
	};

	class CEG_WindowHeaderText : CEG_Window
	{
		x = (safeZoneX + (safeZoneW * 0.3125));
		y = (safeZoneY + (safeZoneH * 0.3));
		w = (safeZoneW * 0.372);
		h = (safeZoneH * 0.05);
		style = ST_LEFT;		
		colorText[] = CEG_COLOR_WHITE;
		colorBackground[] = CEG_COLOR_CLEAR;
		text = "Chernarus Electrical Grid Remote Access Logon";
	};
	
	class CEG_WindowIconPicture : CEG_StaticPicture
	{
		style = ST_PICTURE + ST_KEEP_ASPECT_RATIO;
		x = (safeZoneX + (safeZoneW * 0.277));
		y = (safeZoneY + (safeZoneH * 0.3));
		w = (safeZoneW * 0.03);
		h = (safeZoneH * 0.05);
		text = "CEG\Textures\WindowIcon.paa";
	};

	 class CEG_PasswordInput : CEG_EditText
	{
		idc = 20901;
		x = (safeZoneX + (safeZoneW * 0.425));
		y = (safeZoneY + (safeZoneH * 0.425));
		w = (safeZoneW * 0.2);
		h = (safeZoneH * 0.04);
	};
	
	class CEG_IncorrectText : CEG_StaticText
	{
		idc = 20902;
		x = (safeZoneX + (safeZoneW * 0.325));
		y = (safeZoneY + (safeZoneH * 0.375));
		w = (safeZoneW * 0.3);
		h = (safeZoneH * 0.04);
		colorText[] = CEG_COLOR_RED;
		colorBackground[] = CEG_COLOR_CLEAR;
	};
	
	class CEG_PasswordLabel : CEG_StaticText
	{
		x = (safeZoneX + (safeZoneW * 0.325));
		y = (safeZoneY + (safeZoneH * 0.425));
		w = (safeZoneW * 0.1);
		h = (safeZoneH * 0.04);
		colorBackground[] = CEG_COLOR_CLEAR;
		text = "Password:";
	};
	
	class CEG_OKButton : CEG_Button
	{
		x = (safeZoneX + (safeZoneW * 0.325));
		y = (safeZoneY + (safeZoneH * 0.475));
		w = (safeZoneW * 0.125);
		h = (safeZoneH * 0.05);
		text = "OK";
		action = "call CEG_fnc_password";
		default = true;
	};
  
	class CEG_CancelButton : CEG_Button
	{
		x = (safeZoneX + (safeZoneW * 0.5));
		y = (safeZoneY + (safeZoneH * 0.475));
		w = (safeZoneW * 0.125);
		h = (safeZoneH * 0.05);
		text = "CANCEL";
		action = "closeDialog 20900;";
	};
};